using System;
using System.Data;
using System.IO;
using System.Collections;
using Server;
using Server.Items;
using Server.Network;
using Server.Gumps;
using Server.Targeting;
using System.Reflection;
using Server.Commands;
using CPA = Server.CommandPropertyAttribute;
using System.Xml;
using Server.Spells;
using System.Text;
using Server.Accounting;
using System.Diagnostics;



namespace Server.Mobiles
{
	public class XmlQuestNPCElf : TalkingBaseCreature
	{

        [Constructable]
        public XmlQuestNPCElf() : this(-1)
        {
        }

        [Constructable]
        public XmlQuestNPCElf(int gender) : base( AIType.AI_Melee, FightMode.None, 10, 1, 0.8, 3.0 )
        {
            SetStr( 10, 30 );
            SetDex( 10, 30 );
            SetInt( 10, 30 );

            Fame = 50;
            Karma = 50;

            CanHearGhosts = true;

            SpeechHue = Utility.RandomDyedHue();
            Title = string.Empty;
            Hue = Utility.RandomSkinHue();
            
            switch(gender)
            {
                case -1: this.Female = Utility.RandomBool(); break;
                case 0: this.Female = false; break;
                case 1: this.Female = true; break;
            }

            if ( this.Female)
            {
                this.Body = 0x25E;
                this.Name = NameList.RandomName( "female" );
                Item hair = new Item( Utility.RandomList( 0x2FBF, 0x2FC0, 0x2FC1, 0x2FC2, 0x2FCC, 0x2FCD, 0x2FCE, 0x2FCF, 0x2FD0, 0x2FD1, 0x2FD1 ) );
                hair.Hue = Utility.RandomHairHue();
                hair.Layer = Layer.Hair;
                hair.Movable = false;
                AddItem( hair );
                Item pants = null;
                switch ( Utility.Random( 4 ) )
                {
                    case 0: pants = new ShortPants( GetRandomHue() );	break;
                    case 1: pants = new LongPants( GetRandomHue() );	break;
                    case 2: pants = new Skirt( GetRandomHue() );		break;
                    case 3: pants = new ElvenPants( GetRandomHue() );		break;
                }
                AddItem( pants );
                Item shirt = null;
                switch ( Utility.Random( 8 ) )
                {
                    case 0: shirt = new Doublet( GetRandomHue() );		break;
                    case 1: shirt = new ElvenShirt( GetRandomHue() );		break;
                    case 2: shirt = new FemaleElvenRobe( GetRandomHue() );		break;
                    case 3: shirt = new FancyDress( GetRandomHue() );	break;
                    case 4: shirt = new PlainDress( GetRandomHue() );	break;
                    case 5: shirt = new FancyShirt( GetRandomHue() );	break;
                    case 6: shirt = new Shirt( GetRandomHue() );		break;
                    case 7: shirt = new ElvenDarkShirt( GetRandomHue() );		break;
                }
                AddItem( shirt );
            }
            else
            {
                this.Body = 0x25D;
                this.Name = NameList.RandomName( "male" );
                Item hair = new Item( Utility.RandomList( 0x2FBF, 0x2FC0, 0x2FC1, 0x2FC2, 0x2FCC, 0x2FCD, 0x2FCE, 0x2FCF, 0x2FD0, 0x2FD1, 0x2FD1 ) );
                hair.Hue = Utility.RandomHairHue();
                hair.Layer = Layer.Hair;
                hair.Movable = false;
                AddItem( hair );
                Item pants = null;
                switch ( Utility.Random( 3 ) )
                {
                    case 0: pants = new ShortPants( GetRandomHue() );	break;
                    case 1: pants = new LongPants( GetRandomHue() );	break;
                    case 2: pants = new ElvenPants( GetRandomHue() );		break;
                }
                AddItem( pants );
                Item shirt = null;
                switch ( Utility.Random( 8 ) )
                {
                    case 0: shirt = new Doublet( GetRandomHue() );		break;
                    case 1: shirt = new Surcoat( GetRandomHue() );		break;
                    case 2: shirt = new Tunic( GetRandomHue() );		break;
                    case 3: shirt = new FancyShirt( GetRandomHue() );	break;
                    case 4: shirt = new Shirt( GetRandomHue() );		break;
                    case 5: shirt = new ElvenDarkShirt( GetRandomHue() );		break;
                    case 6: shirt = new ElvenShirt( GetRandomHue() );		break;
                    case 7: shirt = new MaleElvenRobe( GetRandomHue() );		break;
                }
                AddItem( shirt );
            }

            Item feet = null;
            switch ( Utility.Random( 3 ) )
            {
                case 0: feet = new Boots( Utility.RandomNeutralHue() );	break;
                case 1: feet = new Shoes( Utility.RandomNeutralHue() );	break;
                case 2: feet = new Sandals( Utility.RandomNeutralHue() );		break;
                case 3: feet = new ElvenBoots( Utility.RandomNeutralHue() );		break;
            }
            AddItem( feet );
            Container pack = new Backpack();

            pack.DropItem( new Gold( 0, 50 ) );

            pack.Movable = false;

            AddItem( pack );
        }

        public XmlQuestNPCElf( Serial serial ) : base( serial )
        {
        }

		

        private static int GetRandomHue()
        {
            switch ( Utility.Random( 6 ) )
            {
                default:
                case 0: return 0;
                case 1: return Utility.RandomBlueHue();
                case 2: return Utility.RandomGreenHue();
                case 3: return Utility.RandomRedHue();
                case 4: return Utility.RandomYellowHue();
                case 5: return Utility.RandomNeutralHue();
            }
        }


        public override void Serialize( GenericWriter writer )
        {
            base.Serialize( writer );

            writer.Write( (int) 0 ); // version

        }

        public override void Deserialize( GenericReader reader )
        {
            base.Deserialize( reader );

            int version = reader.ReadInt();

        }
    }
}
